#include "stddefs.fxh"
#include "lighting_globals.fxh"

// this is the effect file for the skydome
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
	bool dynamic = true;
>;

float4 LightDir 			: LIGHTDIRECTION
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vSunColorIntensity 	: SUNCOLORINTENSITY
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vBetaRayleigh 		: BETARAYLEIGH
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vBetaDashRayleigh 	: BETADASHRAYLEIGH
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vBetaMie 			: BETAMIE
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vBetaDashMie 		: BETADASHMIE
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vBetaRayleighMie 	: BETARAYLEIGHMIE
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vOneOverBetaRM 		: ONEOVERBETARAYLEIGHMIE
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vHG 					: HENYEYGG
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vEyePos 				: EYEPOSITION
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vDensityAlt 			: DENSDIST
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;

float4 vToneMap 			: TONEMAP
<
	string UIWidget = "None";
	bool appEdit = true;
	bool export = true;
>;


float4 vConstants = {1.0f ,-1.4426950f, 0.01f, 1000.0f } ; // constants

struct VS_OUTPUT
{
	float4 Pos : POSITION;
	float4 Diff : COLOR0;
};

VS_OUTPUT VS(float3 vPos : POSITION, float3 Norm: NORMAL)
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
	
	// transform
	Out.Pos = mul ( float4 ( vPos , 1 ) , worldviewproj ) ;
	
	// determine angle between sun and view direction
	float4 viewAngle ;
	viewAngle.x = dot( LightDir.xyz ,Norm) ;
	
	viewAngle.y = ( viewAngle.x * viewAngle.x ) / 2 + 2 ;
	//viewAngle.y = ( viewAngle.x * viewAngle.x ) + 1;			//PhaseRayleigh   == cos^2(theta) + 1
	
	float scaledHeight = clamp( (vPos.y / 3800.0f) , 0.0f, 1.0f);
	
	
	viewAngle.z = lerp (scaledHeight, vDensityAlt.z, scaledHeight); 
	viewAngle.w = scaledHeight;
	viewAngle.w = lerp( viewAngle.w, vDensityAlt.w, scaledHeight );  //Nielsens alternative to distance through atmosphere
	
	//viewAngle.w = lerp(Tex.y / 2.0f, 10000, 19000);
	
	// calculate extinction terms for inscatered extinction
	float3 extinction;
	extinction = vBetaRayleigh * viewAngle.z + vBetaMie * viewAngle.w;
	extinction = exp(-extinction);
	
	//My own alternative to using the extinction caclulation, its not 'correct' but it doesn't turn the horizon red
	//float robsExtinctionTerm = 1.0f - scaledHeight;
	//robsExtinctionTerm =  robsExtinctionTerm * robsExtinctionTerm;
	
	
	// calculate mie scatering term
	//Phase2 ( theta ) = (1-g 2) /(1+g2-2g * cos ( theta ) ) (3/2)
	//vHG = [1-g 2 , 1+g2, -2g , insc ]
	
	float4 phaseThetaMie ;
	phaseThetaMie.x = vHG.z * viewAngle.x + vHG.y;
	phaseThetaMie.y = rsqrt( phaseThetaMie.x);
	phaseThetaMie.z = pow( phaseThetaMie.y, 3);
	phaseThetaMie.w = phaseThetaMie.z * vHG.x;  //PhaseMie theta
	
	// Inscattering ( I ) = ( BetaR * PhaseR( theta ) + BetaM * PhaseM( theta ) ) *
	// [1-exp(-Beta R*s ) . exp(-Beta M*s ) ] / ( Beta R + Beta M)
	float3 rayleigh;
	rayleigh = vBetaDashRayleigh * viewAngle.y;
	float3 mie;
	mie = vBetaDashMie * phaseThetaMie.w;
	
	float3 temp = vConstants.x - extinction;
	
	
	mie /= 5.0f; //5.0f works if log is switched on ~40 otherwise
	
	
	float3 inscatter; // I ( inscattering )
	inscatter =(rayleigh * vOneOverBetaRM) + mie;
	
	
	inscatter = (extinction * inscatter) + inscatter; //used to be inscatter *= temp;
	
	inscatter *= vSunColorIntensity.xyz;
	inscatter *= vSunColorIntensity.w;
	
	inscatter.x = log(1.0f + inscatter.x);
	inscatter.y = log(1.0f + inscatter.y);
	inscatter.z = log(1.0f + inscatter.z);
	
	
	// color
	inscatter.z+=0.15f;
	
	float4	output_colour = float4(inscatter, 1.0f);
	APPLY_DISTANCE_FOG( output_colour, 0.5f );
	Out.Diff=CalculateOutputPixel( output_colour );
	
	return Out;
}

// PS
COLOUR_OUTPUT_TYPE PS(VS_OUTPUT In ) : COLOR
{
	float4 Color = ( float4 )0;
	float4 Temp = ( float4 )0;
	Color = In.Diff;
	return Color;
}

//Technique T0, rendering the skydome with a constantcolor
// in a single pass, no scatering, no shaders
technique T
<
	bool supportsSpecialisedLighting = false;
  bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "T";
	int    normalDeferredID		= 0;
	string zprimeBehaviour		= "ERMB_RENDER_DEFAULT";
	string zprimeDOFBehaviour	= "ERMB_DONT_RENDER";
	string shadowGenBehaviour = "ERMB_RENDER_DEFAULT";
>
{
pass P0
  {
	ZEnable = false;
	ZWriteEnable = false;
	AlphaBlendEnable = false;

#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx VS();
		PixelShader = compile sce_fp_rsx PS();
#else
  VertexShader = compile  vs_3_0 VS( );
  PixelShader = compile ps_3_0 PS( );
#endif
  }
}
